﻿using Helper;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ZSMusic.IDAL;
using ZSMusic.Model;

namespace ZSMusic.DAL.Platforms
{
    public class kg : IMusic
    {
        public List<Music> Search(string word, int page, int num)
        {
            List<Music> list = new List<Music>();
            string src = HttpHelper.Get(string.Format(
                "http://mobilecdn.kugou.com/api/v3/search/song?format=jsonp&keyword={0}&page={1}&pagesize={2}&showtype=1"
                , word, page, num));
            JObject jobject = (JObject)JsonConvert.DeserializeObject(src.Trim(new char[] { '(', ')' }));
            if (Convert.ToInt32(jobject["data"]["total"]) <= 0)
            {
                return list;
            }
            foreach (JToken jtoken in ((IEnumerable<JToken>)jobject["data"]["info"]))
            {
                Music m = new Music
                {
                    Id = jtoken["hash"].ToString(),
                    Artist = jtoken["singername"].ToString(),
                    Name = jtoken["filename"].ToString(),
                    Source = "kg",
                    AlbumId = jtoken["hash"].ToString(),
                    Album = jtoken["othername_original"].ToString()
                };
                if (string.IsNullOrEmpty(m.Artist))
                {
                    if (m.Name.Contains("-"))
                    {
                        Music m2 = m;
                        m2.Artist = m2.Name.Substring(0, m.Name.IndexOf('-')).Trim();
                        Music m3 = m;
                        m3.Name = m3.Name.Substring(m.Name.IndexOf('-') + 1).Trim();
                    }
                }
                else
                {
                    string b = m.Name.Substring(0, m.Name.IndexOf('-')).Trim();
                    if (m.Artist.Trim() == b)
                    {
                        Music m4 = m;
                        m4.Name = m4.Name.Substring(m.Name.IndexOf('-') + 1).Trim();
                    }
                }
                Music m5 = m;
                m.ToString();
                list.Add(m);
            }
            return list;
        }

        public List<Music> SearchCollection(string id)
        {
            List<Music> list = new List<Music>();
            for (int i = 1; true; i++)
            {
                List<Music> result = SearchCollection(id, i);
                if (result.Count > 0)
                { list.AddRange(result); }
                else { break; }
            }
            return list;
        }

        private List<Music> SearchCollection(string id, int page)
        {
            List<Music> list = new List<Music>();
            string src = HttpHelper.Get(string.Format("http://m.kugou.com/plist/list/?specialid={0}&page={1}&plat=2&json=true", id, page));
            JArray array = JArray.Parse(StringEx.GetMiddleText(src, "info\":", ",\"total"));
            foreach (var item in array)
            {
                Music m = new Music();
                m.Id = item["hash"].ToString();
                string[] name = item["filename"].ToString().Replace('、', ',').Split('-');
                m.Artist = name[0].Trim();
                m.Name = name[1].Trim();
                m.Album = item["remark"].ToString();
                m.AlbumId = m.Id;
               m.ToString();
                m.Source = "kg";
                list.Add(m);
            }
            return list;
        }

        public List<Music> SearchAlbum(string id)
        {
            throw new NotImplementedException();
        }

        public bool GetData(Music m, string type = "all")
        {
            switch (type)
            {
                case "all":
                    GetPic(m);
                    GetLrc(m);
                    return GetUrl(m);
                case "url":
                    return GetUrl(m);
                case "pic":
                    return GetPic(m);
                case "lrc":
                    return GetLrc(m);
                default:
                    throw new NotImplementedException(type);
            }
        }

        private bool GetUrl(Music m)
        {
            string Src = StringEx.GetMiddleText(HttpHelper.Get(string.Format(
     "http://yinle.rzzkk520.cn/api.php?callback=jQuery11130182920795747622_1585018563804&types=url&id={0}&source=kugou"
     , m.Id)), "jQuery11130182920795747622_1585018563804(", ")");//.Trim(new char[]{'(',')'});
            m.Url = StringEx.ExactJson(Src, "url").Replace("\\", "");
            return HttpHelper.CheckUri(m.Url);
        }

        private bool GetLrc(Music m)
        {
            string Lrcsrc = StringEx.GetMiddleText(HttpHelper.Get(string.Format(
     "http://yinle.rzzkk520.cn/api.php?callback=jQuery11130182920795747622_1585018563804&types=lyric&id={0}&source=kugou"
     , m.Id)), "jQuery11130182920795747622_1585018563804(", "})") + "}";
            m.Lrc = StringEx.ExactJson(Lrcsrc, "lyric").Trim().Replace("\\n", "\n").Replace("\\r", "");
            return !string.IsNullOrWhiteSpace(m.Lrc);
        }

        private bool GetPic(Music m)
        {
            string picsrc = StringEx.GetMiddleText(HttpHelper.Get(string.Format(
     "http://yinle.rzzkk520.cn/api.php?callback=jQuery11130182920795747622_1585018563804&types=pic&id={0}&source=kugou"
     , m.AlbumId)), "jQuery11130182920795747622_1585018563804(", ")");
            m.PicUrl = StringEx.ExactJson(picsrc, "url").Replace("\\", "");
            return HttpHelper.CheckUri(m.Url);
        }
    }
}
